% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treedater0.R
\name{rootToTipRegressionPlot}
\alias{rootToTipRegressionPlot}
\title{Plot evolutionary distance from root to sample times and estimated internal node times and regression lines}
\usage{
rootToTipRegressionPlot(
  td,
  show.tip.labels = FALSE,
  textopts = NULL,
  pointopts = NULL,
  ...
)
}
\arguments{
\item{td}{A fitted treedater object}

\item{show.tip.labels}{If TRUE, the names of each sample will be plotted at the their corresponding time and evolutionary distance}

\item{textopts}{An optional list of parameters for plotted tip labels. Passed to the *text* function.}

\item{pointopts}{An optional list of parameters for plotted points if showing tip labels. Passed to the *points* function.}

\item{...}{Additional arguments are passed to plot}
}
\value{
The fitted linear model (class 'lm')
}
\description{
If a range of sample times was given, these will be estimated. Red and black respectively indicate sample and internal nodes.
This function will print statistics computed from the linear regression model.
}
\examples{
## simulate a random tree and sample times for demonstration
# make a random tree:
tre <- ape::rtree(50)
# sample times based on distance from root to tip:
sts <- setNames( ape::node.depth.edgelength( tre )[1:ape::Ntip(tre)], tre$tip.label)
# modify edge length to represent evolutionary distance with rate 1e-3:
tre$edge.length <- tre$edge.length * 1e-3
# treedater:
td <- dater( tre, sts =sts, clock='strict', s = 1000, omega0=.0015 )
# root to tip regression:
fit = rootToTipRegressionPlot( td )
summary(fit)

}
