% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_interaction.R
\name{plot_interaction}
\alias{plot_interaction}
\title{SHAP Interaction value plot}
\usage{
plot_interaction(
  treeshap,
  var1,
  var2,
  title = "SHAP Interaction Value Plot",
  subtitle = ""
)
}
\arguments{
\item{treeshap}{A treeshap object produced with \code{\link{treeshap}(interactions = TRUE)} function. \code{\link{treeshap.object}}.}

\item{var1}{name or index of the first variable - plotted on x axis.}

\item{var2}{name or index of the second variable - marked with color.}

\item{title}{the plot's title, by default \code{'SHAP Interaction Value Plot'}.}

\item{subtitle}{the plot's subtitle. By default no subtitle.}
}
\value{
a \code{ggplot2} object
}
\description{
This function plots SHAP Interaction value for two variables depending on the value of the first variable.
Value of the second variable is marked with the color.
}
\examples{
\donttest{
data <- fifa20$data[colnames(fifa20$data) != 'work_rate']
target <- fifa20$target
param2 <- list(objective = "reg:squarederror", max_depth = 5)
xgb_model2 <- xgboost::xgboost(as.matrix(data), params = param2, label = target, nrounds = 10)
unified_model2 <- xgboost.unify(xgb_model2, data)
inters <- treeshap(unified_model2, as.matrix(data[1:50, ]), interactions = TRUE)
plot_interaction(inters, "dribbling", "defending")
}
}
\seealso{
\code{\link{treeshap}} for calculation of SHAP Interaction values

\code{\link{plot_contribution}}, \code{\link{plot_feature_importance}}, \code{\link{plot_feature_dependence}}
}
