% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_post-order.R
\name{create_order_body}
\alias{create_order_body}
\title{Create order body}
\usage{
create_order_body(
  recipient_name,
  recipient_email = NULL,
  recipient_phone = NULL,
  reward_amount,
  currency_code = "USD",
  delivery_method = "EMAIL",
  payment_description_id,
  funding_source_id,
  reward_types
)
}
\arguments{
\item{recipient_name}{Name of the recipient.}

\item{recipient_email}{Email address of the recipient.}

\item{recipient_phone}{Phone number of the recipient (US phone numbers only).}

\item{reward_amount}{Amount of the reward (numeric).}

\item{currency_code}{Currency of the reward (default to "USD").}

\item{delivery_method}{Default to "EMAIL", for sending the reward to the
recipient via email. Alternatively, reward can be delivered via a link
("LINK") or text message ("PHONE").}

\item{payment_description_id}{Unique ID for specific order. This will appear
as \code{external_id} on Tremendous Dashboard.}

\item{funding_source_id}{ID of the funding source linked to your account, to
draw funds from for this order. One of the IDs from
\code{trem_get("funding_sources")}.}

\item{reward_types}{A character vector of product ids -- reward options --
for the recipient to choose from. Available options can be found
\href{https://www.tremendous.com/catalog}{here}.}
}
\value{
A nested list that, when converted to JSON, is accepted by
'Tremendous' API's create order endpoint.
}
\description{
Utility Function to Create an Order on Tremendous. For full API
documentation, see
\url{https://developers.tremendous.com/reference/core-orders-create}.
}
\keyword{internal}
