% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_source_model.R
\name{one_source_model}
\alias{one_source_model}
\title{Bayesian model - One Source Trophic Position}
\usage{
one_source_model(bp = FALSE)
}
\arguments{
\item{bp}{logical value that controls whether informed priors are
supplied to the model for \eqn{\delta^{15}}N baseline.
Default is \code{FALSE} meaning the model will use uninformed priors, however,
the supplied \code{data.frame} needs values for  \eqn{\delta^{15}}N
baseline (\code{n1}).}
}
\value{
returns model structure for one source model to be used in a
\code{brms()} call.
}
\description{
Estimate trophic position using a one source model derived from
\href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002} using a Bayesian framework.
}
\details{
\deqn{\delta^{15}N = \delta^{15} N_1  + \Delta N \times (tp - \lambda_1)}

\eqn{\delta^{15}}N are values from the consumer,
\eqn{\delta^{15} N_1} is mean \eqn{\delta^{15}}N values of baseline 1,
\eqn{\Delta}N is the trophic discrimination factor for N (i.e., \code{dn} mean
of \code{3.4}), \eqn{tp} is trophic position, and \eqn{\lambda_1} is the
trophic level of baselines which are often a primary consumer (e.g., \code{2}).

The data supplied to \code{brms()} needs to have the following variables \code{d15n},
\code{n1}, and \code{l1} (\eqn{\lambda}) which is usually \code{2}.
}
\examples{
one_source_model()

}
\seealso{
\code{\link[brms:brms-package]{brms::brms()}}
}
