% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_source_priors_ar.R
\name{two_source_priors_ar}
\alias{two_source_priors_ar}
\title{Bayesian priors - Two Source Trophic Position with \eqn{\alpha_r}}
\usage{
two_source_priors_ar(bp = FALSE)
}
\arguments{
\item{bp}{logical value that controls whether informed priors are
supplied to the model for  \eqn{\delta^{15}}N baselines.
Default is \code{FALSE} meaning the model will
use uninformed priors, however, the supplied \code{data.frame} needs values
for both \eqn{\delta^{15}}N baseline
(\code{n1}, and \code{n2}).}
}
\value{
returns priors for two source model to be used in a \code{brms()} call.
}
\description{
Create priors for trophic position using a two source model
with \eqn{\alpha_r} derived from \href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}
and Heuvel et al. (2024) \doi{doi:10.1139/cjfas-2024-0028}.
}
\examples{
two_source_priors_ar()

}
\seealso{
\code{\link[brms:brms-package]{brms::brms()}}
}
