% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HACLasso.r
\name{lambdaCalculationHAC}
\alias{lambdaCalculationHAC}
\title{\code{lambdaCalculationHAC} is an auxiliary function for rlassoHAC; it calculates the penalty parameters.}
\source{
Victor Chernozhukov, Chris Hansen, Martin Spindler (2016). hdm: High-Dimensional Metrics,
R Journal, 8(2), 185-199. URL https://journal.r-project.org/archive/2016/RJ-2016-040/index.html.
}
\usage{
lambdaCalculationHAC(
  X.dependent.lambda = FALSE,
  c = 2,
  gamma = 0.1,
  kernel,
  bands,
  bns,
  lns,
  nboot,
  y = NULL,
  x = NULL
)
}
\arguments{
\item{X.dependent.lambda}{Logical, TRUE, if the penalization parameter depends on the design 
of the matrix x. FALSE, if independent of the design matrix (default).}

\item{c}{Constant for the penalty with default c = 2 .}

\item{gamma}{Constant for the penalty with default gamma=0.1.}

\item{kernel}{String  kernel function, choose between "Truncated", "Bartlett", "Parzen", 
"Tukey-Hanning", "Quadratic Spectral".}

\item{bands}{Constant bandwidth parameter.}

\item{bns}{Block length.}

\item{lns}{Number of blocks.}

\item{nboot}{Number of bootstrap iterations.}

\item{y}{Residual which is used for calculation of the variance or the data-dependent loadings.}

\item{x}{Regressors (vector, matrix or object can be coerced to matrix).}
}
\value{
\item{lambda0}{Penalty term}
\item{Ups0}{Penalty loadings, vector of length p (no. of regressors)}
\item{lambda}{This is lambda0 * Ups0}
\item{penalty}{Summary of the used penalty function.}
}
\description{
\code{lambdaCalculationHAC} is an auxiliary function for rlassoHAC; it calculates the penalty parameters.
}
