% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{initialize_simulator}
\alias{initialize_simulator}
\title{Simulator Initializer}
\usage{
initialize_simulator(x, index = NULL, sampling = NULL, model = "issm", ...)
}
\arguments{
\item{x}{a vector of zero mean errors to use in the model.}

\item{index}{an optional Date or POSIXct vector of same length as x. Used
for indexing the simulated values.}

\item{sampling}{an optional string denoting the sampling frequency for the
simulator. If no index is present, will automatically generate one based on
the sampling frequency given with start date 2000-01-01. Valid sampling
frequencies are days, weeks, months, years, secs, mins, hours and subintervals
of those as documented in the \code{\link{seq.POSIXt}} function.}

\item{model}{the type of model to initialize a class for.}

\item{...}{additional parameters to the function (not currently used).}
}
\value{
A object whose class depends on the type of model used.
}
\description{
Simulator Initializer
}
