% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{write_results}
\alias{write_results}
\title{Write a selection of relevant results to disc}
\usage{
write_results(res, res.dir, Y, n.ahead, confidence.level)
}
\arguments{
\item{res}{Results object estimated using the \samp{estimate()} method.}

\item{res.dir}{File path to save the results to.}

\item{Y}{Cumulated variable.}

\item{n.ahead}{Number of periods ahead to forecast.}

\item{confidence.level}{Confidence level to use for the confidence interval
on the forecasts \eqn{\ln(g_t)}.}
}
\value{
A number of csv files saved in the directory specified in
\code{res.dir}.
}
\description{
Function writes the following results to csv files which get
saved in the location specified in \code{res.dir}: forecast new cases or
incidence variable, \eqn{y}; the filtered level and slope of \eqn{\ln g},
\eqn{\delta} and \eqn{\gamma}; filtered estimates of \eqn{g_y} and the
confidence intervals for these estimates.
}
\examples{
# Not run as do not wish to save to local disc when compiling documentation.
# Below will run if copied and pasted into console.
library(tsgc)
library(here)

res.dir <- tempdir()
data(gauteng,package="tsgc")
idx.est <- zoo::index(gauteng) <= as.Date("2020-07-06")
res <- SSModelDynamicGompertz$new(Y = gauteng[idx.est], q = 0.005)$estimate()

tsgc::write_results(
res=res, res.dir = res.dir, Y = gauteng[idx.est], n.ahead = 14,
confidence.level = 0.68
)

}
