% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsprofile.R
\name{tsprofile.tsissm.estimate}
\alias{tsprofile.tsissm.estimate}
\alias{tsprofile}
\title{Model Simulation Based Profiling}
\usage{
\method{tsprofile}{tsissm.estimate}(
  object,
  h = 1,
  nsim = 100,
  seed = NULL,
  solver = "nloptr",
  control = NULL,
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.estimate}.}

\item{h}{the forecast horizon on which to evaluate performance metrics.}

\item{nsim}{the number of paths to generate.}

\item{seed}{an object specifying if and how the random number generator
should be initialized. See the simulate documentation for more details.}

\item{solver}{only \dQuote{nlortr} currently available.}

\item{control}{optional control parameters.
The user is expected to have set up appropriate handlers for this using 
the \code{\link[progressr]{handlers}} function from the \dQuote{progressr} package.}

\item{trace}{whether to show the progress bar and additionally output verbose messages.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tsissm.profile}.
}
\description{
Profiling of model dynamics using simulation/estimation/prediction.
}
\details{
The function profiles an estimated model by simulating and then estimating
multiple paths from the assumed DGP while leaving h values out for prediction
evaluation. Each simulated path is equal to the size of the original dataset
plus h additional values, and initialized with the initial state vector from
the model. The resulting output contains the distribution of the MAPE,
percent bias (BIAS) and mean squared log relative error (MSLRE) per horizon h.
Since these matrices are of class \dQuote{tsmodel.distribution} they can be
readily plotted with the special purpose \dQuote{plot} function for this class
from the \dQuote{tsmethods} package. Additionally, a data.table matrix is
also returned with the distribution of the coefficients from each path estimation.
}
\note{
The function can use parallel functionality as long as the user has set
up a \code{\link[future]{plan}} using the future package.
The simulated states are checked for positivity and any paths which have negative
values are excluded. If more than half of the paths have negative values then
an error is raised and the function will stop.
}
