% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv.R
\name{tv}
\alias{tv}
\alias{time_varying}
\alias{check_tv_data}
\alias{check_tv_exposure}
\alias{check_tv_specs}
\title{Create a time-varying dataset}
\usage{
time_varying(
  x,
  specs,
  exposure,
  ...,
  grid.only = FALSE,
  time_units = c("days", "seconds"),
  id = "pat_id",
  sort = NA,
  n_cores = as.numeric(Sys.getenv("SLURM_CPUS_PER_TASK", 1))
)

check_tv_data(x, time_units, id, sort)

check_tv_exposure(x, expected_ids, time_units, id, ..., check_overlap = TRUE)

check_tv_specs(specs, expected_features = NULL)
}
\arguments{
\item{x}{A data.frame with four columns: <id>, "feature", "datetime", "value"}

\item{specs}{a data.frame with four columns: "feature", "use_for_grid", "lookback_start", "lookback_end", "aggregation". See details below.}

\item{exposure}{a data.frame with (at least) three columns: <id>, "exposure_start", "exposure_stop"}

\item{...}{Other arguments. Currently just passes \code{check_overlap}.}

\item{grid.only}{Should just the grid be computed and returned? Useful only for debugging}

\item{time_units}{What time units should be used? Seconds or days}

\item{id}{The id to use. Default is "pat_id"}

\item{sort}{Logical, indicating whether to sort the data before performing the analysis. By default (\code{NA}),
sorting is only done when useful (that is: \code{x$datetime} is a POSIXct and \code{time_units == "days"}).
A warning is issued when \code{x$datetime} is a Date to make the user aware that the input ought to be sorted to
get the right answer.}

\item{n_cores}{Number of cores to use. If slurm is being used, it checks the \code{SLURM_CPUS_PER_TASK} variable.
Else it defaults to 1, for no parallelization.}

\item{expected_ids}{A vector of expected ids based on the data.}

\item{check_overlap}{Should overlap be checked among exposure rows? A potentially costly operation,
so you can opt out of it if you're really sure.}

\item{expected_features}{A vector of expected features based on the data.}
}
\value{
A data.frame, with one row per grid value and one column per feature specification (plus grid columns).
}
\description{
Create a time-varying dataset
}
\details{
The defaults for specs are to use everything for the grid creation, and to set \code{lookback_start=0}, with a message in both cases.
  Currently supported aggregation functions include counting ("count" or "n"), last-value-carried forward ("last value" or "lvcf"),
  any/none ("any" or "binary"), time since ("time since" or "ts"), min/max/mean, and the special "event" (for which look backs are ignored).

  The look back window begins at \code{row_start - lookback_end} and ends at \code{row_start - lookback_start}. Passing NA to either look back
  changes the corresponding window boundary to \code{exposure_start}.
}
\examples{
  data(tv_example)
  time_varying(tv_example$data, tv_example$specs, tv_example$exposure,
               time_units = "days", id = "mcn")
}
