% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{FastSpectralNJW}
\alias{FastSpectralNJW}
\title{Jordan Fast Spectral Algorithm}
\usage{
FastSpectralNJW(data, nK = NULL, Kech = 2000, StopCriteriaElbow = 0.97,
  neighbours = 7, method = "", nb.iter = 10, uHMMinterface = FALSE,
  console = NULL, tm = NULL)
}
\arguments{
\item{data}{numeric matrix or dataframe.}

\item{nK}{number of clusters desired. If NULL, optimal number of clusters will be computed using gap criteria.}

\item{Kech}{maximum number of representative points in sampled data.}

\item{StopCriteriaElbow}{maximum (minimum ?) de variance expliquees des points representatifs souhaite.}

\item{neighbours}{number of neighbours considered for the computation of local scale parameters.}

\item{method}{string specifying the spectral classification method desired, either "PAM" (for spectral kmedoids) or "" (for "spectral kmeans").}

\item{nb.iter}{number of iterations.}

\item{uHMMinterface}{logical indicating whether the function is used via the uHMMinterface.}

\item{console}{frame of the uHMM interface in which messages should be displayed (only if uHMMinterface=TRUE).}

\item{tm}{a one row dataframe containing text to display in the uHMMinterface (only if uHMMinterface=TRUE).}
}
\value{
The function returns a list containing:
\item{sim}{similarity matrix of representative points, multiplied by its transpose (\code{\link{ZPGaussianSimilarity}}).}
\item{label}{vector of cluster sequencing.}
\item{gap}{number of clusters.}
\item{labelElbow}{vector of prototype sequencing.}
\item{vpK}{matrix containing, in columns, the K first normalised eigen vectors of the data similarity matrix.}
\item{valp}{vector containing the K first eigen values of the data similarity matrix.}
\item{echantillons}{matrix of prototypes coordinates.}
\item{label.echantillons}{vector containing the cluster of each prototype.}
\item{numSymbole}{vector containing the nearest prototype of each data item.}
}
\description{
Perform the Jordan spectral algorithm for large databases. Data are sampled, using K-means with Elbow criteria, before being classified.
}
\details{
Algorithme de Jordan pour un grand jeu de donnees : echantillonage puis spectral
}
\examples{
x=(runif(1000)*4)-2;y=(runif(1000)*4)-2
keep<-which((x**2+y**2<0.5)|(x**2+y**2>1.5**2 & x**2+y**2<2**2 ))
data<-data.frame(x,y)[keep,]

cl<-FastSpectralNJW(data,2)
plot(data,col=cl$label)

}
\seealso{
\code{\link{KmeansAutoElbow}} \code{\link{ZPGaussianSimilarity}}  \code{\link[class]{knn}} 
\code{\link[cluster]{silhouette}} \code{\link[clValid]{dunn}} \code{\link[clValid]{connectivity}} \code{\link[stats]{dist}}
}

