% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{computeGap}
\alias{computeGap}
\title{Compute gap between eigenvalues of a similarity matrix}
\usage{
computeGap(similarity, Gmax)
}
\arguments{
\item{similarity}{a similarity matrix.}

\item{Gmax}{the maximum gap value allowed (only the first Gmax eigenvalues will be taken into account).}
}
\value{
The function returns a list containing the following components:

\item{gap}{a vector indicating the gap between similarity matrix eigenvalues (the gap between the 2 first eigenvalues is set to 0)}

\item{Kmax}{an integer indicating the index of the highest gap (the highest gap is between the Kmax-th and the (Kmax+1)-th eigenvalues)}
}
\description{
Find the highest gap between eigenvalues of a similarity matrix.
The 2 first eigenvalues are considered as equal to each other (the gap between the 2 first eigenvalues is set to 0).
}
\examples{

x <- rbind(matrix(rnorm(50, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(50, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(50, mean = 4, sd = 0.3), ncol = 2))

similarity<-ZPGaussianSimilarity(x,7)
Gap<-computeGap(similarity,10)
plot(1:length(Gap$gap),Gap$gap,type="h",
main=paste("Gap criteria =",Gap$K),ylab="gap value",xlab="eigenvalues")



x=(runif(1000)*4)-2;y=(runif(1000)*4)-2
keep<-which((x**2+y**2<0.5)|(x**2+y**2>1.5**2 & x**2+y**2<2**2 ))
data<-data.frame(x,y)[keep,]
plot(data)

similarity<-ZPGaussianSimilarity(data,1)
Gap<-computeGap(similarity,10)
plot(1:length(Gap$gap),Gap$gap,type="h",
main=paste("Gap criteria =",Gap$K),ylab="gap value",xlab="eigenvalues")

}

