% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Berkeley.R
\docType{data}
\name{berkeley_1}
\alias{berkeley_1}
\title{Primary colors of Berkeley, University of California, USA}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on \href{https://www.berkeley.edu}{Berkeley}'s 
\href{https://brand.berkeley.edu/visual-identity/colors/}{Color manual}.
}
\usage{
berkeley_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{berkeley_1} provides the four primary colors
of \href{https://www.berkeley.edu}{Berkeley, University of California}, USA.
}
\details{
The 4 primary colors are
\code{"Berkeley blue"} (defined as HEX #003262, CMYK 100/71/10/47, Pantone 282),
\code{"California gold"} (defined as HEX #FDB515, CMYK 0/32/100/0, Pantone 123),
\code{"Founders rock"} (defined as HEX #3B7EA1, CMYK 76/34/21/0, Pantone 7697), and
\code{"Medalist"} (defined as HEX #C4820E, CMYK 0/34/98/12, Pantone 7550).


The primary palette is broken into heritage and alternate heritage colors. 

The primary colors, called heritage colors, are \code{Berkeley blue} and \code{California gold}. 
They represent \href{https://www.berkeley.edu}{Berkeley} at the highest level and should be present in all communications. 
These colors look best as spot inks, and do not reproduce as richly in four-color process. 
Never use screens or tints of heritage colors. 

The alternate heritage colors were created to expand the primary palette. 
They may be used to complement the primary heritage colors but should never completely replace them 
as main representations of \href{https://www.berkeley.edu}{Berkeley}. 
For example, \code{Medalist} may replace \code{California gold} in situations 
where a darker gold is needed.

See the \href{https://brand.berkeley.edu/visual-identity/colors/}{Color manual} 
for accessible and suitable combinations.
}
\examples{
berkeley_1
unikn::seecol(berkeley_1, main = "Primary colors of Berkeley") # view color palette

}
\seealso{
\code{\link{berkeley_2}} for secondary colors of Berkeley, University of California; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
