% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpqr-ugumbel.R
\name{ugumbel}
\alias{ugumbel}
\alias{dugumbel}
\alias{pugumbel}
\alias{qugumbel}
\alias{rugumbel}
\title{The unit-Gumbel distribution}
\usage{
dugumbel(x, mu, theta, tau = 0.5, log = FALSE)

pugumbel(q, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

qugumbel(p, mu, theta, tau = 0.5, lower.tail = TRUE, log.p = FALSE)

rugumbel(n, mu, theta, tau = 0.5)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{mu}{location parameter indicating the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.}

\item{theta}{nonnegative shape parameter.}

\item{tau}{the parameter to specify which quantile use in the parametrization.}

\item{log, log.p}{logical; If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; If TRUE, (default), \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
\code{dugumbel} gives the density, \code{pugumbel} gives the distribution function,
\code{qugumbel} gives the quantile function and \code{rugumbel} generates random deviates.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function and random number generation function
for the unit-Gumbel distribution reparametrized in terms of the \eqn{\tau}-th quantile, \eqn{\tau \in (0, 1)}.
}
\details{
Probability density function
\deqn{f(y\mid \alpha ,\theta )=\frac{\theta }{y(1-y)}\exp \left\{ -\alpha -\theta \log \left( \frac{y}{1-y}\right) -\exp \left[ -\alpha -\theta \log \left( \frac{y}{1-y}\right) \right] \right\}}

Cumulative distribution function
\deqn{F(y\mid\alpha,\theta)={\exp }\left[ -{{\exp }}\left( -\alpha \right)\left( \frac{1-y}{y}\right) ^{\theta } \right] }

Quantile function
\deqn{Q(\tau \mid \alpha, \theta)= \frac{\left [-\frac{1}{\log(\tau)  }\right ]^{\frac{1}{\theta}}}{\exp\left ( \frac{\alpha}{\theta} \right )+\left [-\frac{1}{\log(\tau)  }\right ]^{\frac{1}{\theta}}}}

Reparameterization
\deqn{\alpha =  g^{-1}(\mu ) =\theta \log \left( {\frac{1-\mu }{\mu }}\right) +\log \left( -\frac{1}{\log \left( \tau \right) }\right)}

where \eqn{0<y<1} and \eqn{\theta >0} is the shape parameter.
}
\examples{
set.seed(6969)
x <- rugumbel(n = 1000, mu = 0.5, theta = 1.5, tau = 0.5)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.01)
hist(x, prob = TRUE, main = 'unit-Gumbel')
lines(S, dugumbel(x = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
plot(ecdf(x))
lines(S, pugumbel(q = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
plot(quantile(x, probs = S), type = "l")
lines(qugumbel(p = S, mu = 0.5, theta = 1.5, tau = 0.5), col = 2)
}
\references{
Mazucheli, J. and Alves, B., (2021). The unit-Gumbel Quantile Regression Model for Proportion Data. \emph{Under Review}.

Gumbel, E. J., (1941). The return period of flood flows. \emph{The Annals of Mathematical Statistics}, \bold{12}(2), 163--190.
}
\author{
Josmar Mazucheli

Andre F. B. Menezes
}
