% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlfatigue.R
\name{mlfatigue}
\alias{mlfatigue}
\title{Gamma distribution maximum likelihood estimation}
\usage{
mlfatigue(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{\code{reltol} is the relative accuracy requested, defaults
to \code{.Machine$double.eps^0.25}. \code{iterlim} is a positive integer
specifying the maximum number of iterations to be performed before the
program is terminated (defaults to \code{100}).}
}
\value{
\code{mlfatigue} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{alpha} and \code{beta}, with \code{mu=0}, and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Uses Newton-Raphson to estimate the parameters of the Birnbaum--Saunders distribution.
The parameter \code{mu} is set to \code{0}, hence only \code{alpha} and \code{beta} are estmated.
}
\details{
For the density function of the Birnbaum--Saunders distribution see
\link[extraDistr:BirnbaumSaunders]{BirnbaumSaunders}.
}
\examples{
mlfatigue(precip)
}
\references{
From, S. G., & Li, L. (2006). Estimation of the parameters of the Birnbaum<U+2013>Saunders distribution. Communications in Statistics: Theory and Methods, 35(12), 2157<U+2013>2169. https://doi.org/10.1080/03610920600853563
}
