% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-write.R
\name{closure_write}
\alias{closure_write}
\alias{closure_read}
\title{Write CLOSURE results to disk (and read them back in)}
\usage{
closure_write(data, path)

closure_read(path)
}
\arguments{
\item{data}{List returned by \code{closure_generate()}.}

\item{path}{String (length 1). File path where \code{closure_write()} will create
a new folder with the results. Set it to \code{"."} to choose the current
working directory. For \code{closure_read()}, the path to an existing folder
with results.}
}
\value{
\code{closure_write()} returns the path to the new folder it created,
\code{closure_read()} returns a list.
}
\description{
You can use \code{closure_write()} to save the results of
\code{\link[=closure_generate]{closure_generate()}} on your computer. A message will show the exact
location.

The data are saved in a new folder as four separate files, one for each
tibble in \code{closure_generate()}'s output. The folder is named after the
parameters of \code{closure_generate()}.

\code{closure_read()} is the opposite: it reads those files back into R,
recreating the original CLOSURE list. This is useful for later analyses if
you don't want to re-run a lengthy \code{closure_generate()} call.
}
\details{
\code{closure_write()} saves the first three tibbles as CSVs, but the
\code{"results"} tibble becomes a Parquet file. This is much faster and takes up
far less disk space --- roughly 1\% of a CSV file with the same data. Speed
and disk space can be relevant with large result sets.

Use \code{closure_read()} to recreate the CLOSURE list from the folder. One of
the reasons why it is convenient is that opening a Parquet file requires a
special reader. For a more general tool, see
\code{\link[nanoparquet:read_parquet]{nanoparquet::read_parquet()}}.
}
\section{Folder name}{
 The new folder's name should be sufficient to recreate
its CLOSURE results. Dashes separate values, underscores replace decimal
periods. For example:

\preformatted{CLOSURE-3_5-1_0-90-1-5-up_or_down-5}

The order is the same as in \code{closure_generate()}:

\preformatted{
  closure_generate(
    mean = "3.5",
    sd = "1.0",
    n = 90,
    scale_min = 1,
    scale_max = 5,
    rounding = "up_or_down",  # default
    threshold = 5             # default
  )
 }
}

\examples{
data <- closure_generate(
  mean = "2.7",
  sd = "0.6",
  n = 45,
  scale_min = 1,
  scale_max = 5
)

# You should write to a real folder instead;
# or just leave `path` unspecified. I use a
# fake folder just for this example.
path_new_folder <- closure_write(data, path = tempdir())

# In a later session, conveniently read the files
# back into R. This returns the original list,
# identical except for floating-point error.
closure_read(path_new_folder)
}
