% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nass_data.R
\name{nass_data}
\alias{nass_data}
\title{Get data from the Quick Stats query}
\usage{
nass_data(source_desc = NULL, sector_desc = NULL, group_desc = NULL,
  commodity_desc = NULL, short_desc = NULL, domain_desc = NULL,
  domaincat_desc = NULL, agg_level_desc = NULL,
  statisticcat_desc = NULL, state_name = NULL, asd_desc = NULL,
  county_name = NULL, region_desc = NULL, zip_5 = NULL,
  watershed_desc = NULL, year = NULL, freq_desc = NULL,
  reference_period_desc = NULL, token = NULL, format = c("CSV",
  "JSON", "XML"), numeric_vals = FALSE)
}
\arguments{
\item{source_desc}{"Program" - Source of data ("CENSUS" or "SURVEY"). Census
program includes the Census of Ag as well as follow up projects. Survey
program includes national, state, and county surveys.}

\item{sector_desc}{"Sector" - Five high level, broad categories useful to
narrow down choices. ("ANIMALS & PRODUCTS", "CROPS", "DEMOGRAPHICS",
"ECONOMICS", or "ENVIRONMENTAL")}

\item{group_desc}{"Group" - Subsets within sector (e.g., under sector_desc =
"CROPS", the groups are "FIELD CROPS", "FRUIT & TREE NUTS", "HORTICULTURE",
and "VEGETABLES").}

\item{commodity_desc}{"Commodity" - The primary subject of interest (e.g.,
"CORN", "CATTLE", "LABOR", "TRACTORS", "OPERATORS").}

\item{short_desc}{"Data Item" - A concatenation of six columns:
commodity_desc, class_desc, prodn_practice_desc, util_practice_desc,
statisticcat_desc, and unit_desc.}

\item{domain_desc}{"Domain" - Generally another characteristic of operations
that produce a particular commodity (e.g., "ECONOMIC CLASS", "AREA
OPERATED", "NAICS CLASSIFICATION", "SALES"). For chemical usage data, the
domain describes the type of chemical applied to the commodity. The
domain_desc = "TOTAL" will have no further breakouts; i.e., the data value
pertains completely to the short_desc.}

\item{domaincat_desc}{"Domain Category" - Categories or partitions within a
domain (e.g., under domain_desc = "SALES", domain categories include $1,000
TO $9,999, $10,000 TO $19,999, etc).}

\item{agg_level_desc}{"Geographic Level" - Aggregation level or geographic
granularity of the data. ("AGRICULTURAL DISTRICT", "COUNTY",
"INTERNATIONAL", "NATIONAL", "REGION : MULTI-STATE", "REGION : SUB-STATE",
"STATE", "WATERSHED", or "ZIP CODE")}

\item{statisticcat_desc}{"Category" - The aspect of a commodity being
measured (e.g., "AREA HARVESTED", "PRICE RECEIVED", "INVENTORY", "SALES").}

\item{state_name}{"State" - State full name.}

\item{asd_desc}{"Ag District" - Ag statistics district name.}

\item{county_name}{"County" - County name.}

\item{region_desc}{"Region" - NASS defined geographic entities not readily
defined by other standard geographic levels. A region can be a less than a
state (SUB-STATE) or a group of states (MULTI-STATE), and may be specific
to a commodity.}

\item{zip_5}{"Zip Code" - US Postal Service 5-digit zip code.}

\item{watershed_desc}{"Watershed" - Name assigned to the HUC.}

\item{year}{"Year" - The numeric year of the data and can be either a
character or numeric vector. Conditional values are also possible, for
example a character vector of ">=1999" of "1999<=" will give years greater
than or equal to 1999. Right now the logical values can either be
greater/less than or equal to with the logical at either the beginning or
end of a string with the year.}

\item{freq_desc}{"Period Type" - Length of time covered ("ANNUAL", "SEASON",
"MONTHLY", "WEEKLY", "POINT IN TIME"). "MONTHLY" often covers more than one
month. "POINT IN TIME" is as of a particular day.}

\item{reference_period_desc}{"Period" - The specific time frame, within a
freq_desc.}

\item{token}{API key, default is to use the value stored in \code{.Renviron}
which is stored from the \code{\link{nass_set_key}} function. If there is
no API key stored in the environment, a character string can be provided.}

\item{format}{Output format from API call. Defaults to CSV as it is typically
the smallest sized call. Other options are JSON and XML but these are not
recommended. XML currently not supported.}

\item{numeric_vals}{Optional to convert the year, Value, and coefficient of
variation (CV \%) to numerics as opposed to defaulted character values.
Default is to FALSE as some Values have a suppression code. Converting to
numeric will result in suppressed values to be NA.}
}
\value{
A data frame containing query to API.
}
\description{
Sends query to Quick Stats API from given parameter values. Data
  request is limited to 50,000 records per the API. Use
  \code{\link{nass_count}} to determine number of records in query.
}
\examples{

\dontrun{
# Get state values in 2012 for all of the values of agricultural land
nass_data(agg_level_desc = "STATE", year = "2012",
commodity_desc = "AG LAND", domain_desc = "VALUE")
}

\dontrun{
# Get county level values in 2012 for the specific data item
  nass_data(year = 2012, agg_level_desc = "COUNTY",
   short_desc = "AG LAND, INCL BUILDINGS - ASSET VALUE, MEASURED IN $")
}
}
