% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalability.R
\name{optimal.scalability,USL-method}
\alias{optimal.scalability,USL-method}
\alias{optimal.scalability}
\title{Point of optimal scalability of a USL model}
\usage{
\S4method{optimal.scalability}{USL}(object, alpha, beta, gamma)
}
\arguments{
\item{object}{A USL object.}

\item{alpha}{Optional parameter to be used for evaluation instead of the
parameter computed for the model.}

\item{beta}{Optional parameter to be used for evaluation instead of the
parameter computed for the model.}

\item{gamma}{Optional parameter to be used for evaluation instead of the
parameter computed for the model.}
}
\value{
A numeric value for the load where optimal scalability will be
  reached.
}
\description{
Calculate the point of optimal scalability for a specific model.
}
\details{
The point of optimal scalability is defined as:

\deqn{Nopt = \frac{1}{\alpha}}{Nopt = 1 / \alpha}

Below this point the existing capacity is underutilized. Beyond that point
the effects of diminishing returns become visible more and more.

The value can be constructed graphically by projecting the intersection of
the linear scalability bound and the Amdahl asymptote onto the x-axis.

The parameters \code{alpha}, \code{beta} and \code{gamma} are useful to do a
what-if analysis. Setting these parameters override the model parameters and
show how the system would behave with a different contention or coherency
delay parameter.

The point of optimal scalability is undefined if \code{alpha} is zero.

This function accepts a arguments for \code{beta} and \code{gamma} although
the values are not required to perform the calculation. This is on purpose
to provide a coherent interface.
}
\examples{
require(usl)

data(specsdm91)

optimal.scalability(usl(throughput ~ load, specsdm91))
## Optimal scalability will be reached at about 36 virtual users

}
\seealso{
\code{\link{usl}},
  \code{\link{peak.scalability,USL-method}}
  \code{\link{limit.scalability,USL-method}}
}
