% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valplot.R
\name{valplot}
\alias{valplot}
\title{valplot}
\usage{
valplot(
  o,
  p,
  main = NA,
  sub = NA,
  xlab = "Observed value",
  ylab = "Predicted value"
)
}
\arguments{
\item{o}{A numeric vector. Observed values.}

\item{p}{A numeric vector. Predicted values.}

\item{main}{A character value. The main title of the plot.}

\item{sub}{A character value. The subtitle of the plot.}

\item{xlab}{A character value. The x axis label.}

\item{ylab}{A character value. The y axis label.}
}
\value{
A scatter plot of observed and predicted values.
}
\description{
Plots predicted values versus observed values in a  
coordinate system with the same range of both axes.
}
\details{
Circles represent the data, dashed line represents observed = predicted 
and solid line represents an
}
\examples{
obs<-c(1:10)
pred<-c(1, 1 ,3, 5, 4, 5, 6, 8, 11, 10)
t1='Measured variable (unit)'
evalue<-round(e(o=obs, p=pred),2)
maevalue<-round(mae(o=obs, p=pred),1)
t2=paste('E = ', evalue, '; MAE = ', maevalue, ' units')
valplot(o=obs, p=pred, main=t1, sub=t2)
}
\author{
Kristin Piikki, Johanna Wetterlind, Mats Soderstrom and Bo Stenberg, 
E-mail: \email{kristin.piikki@slu.se}
}
