% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.functions.R
\name{cluster.pca.BIC}
\alias{cluster.pca.BIC}
\title{mBIC for subspace clustering}
\usage{
cluster.pca.BIC(X, segmentation, dims, numb.clusters, max.dim,
  flat.prior = FALSE)
}
\arguments{
\item{X}{A matrix with only quantitative variables.}

\item{segmentation}{A vector, segmentation for which likelihood is computed. 
Clusters numbers should be from range [1, numb.clusters].}

\item{dims}{A vector of integers, dimensions of subspaces. Number of 
principal components (fixed or chosen by PESEL criterion) that span each 
subspace.}

\item{numb.clusters}{An integer, number of clusters.}

\item{max.dim}{An integer, upper bound for allowed dimension of a subspace.}

\item{flat.prior}{A boolean, if TRUE (default is FALSE) then flat prior on 
models is used.}
}
\value{
Value of mBIC
}
\description{
Computes the value of modified Bayesian Information Criterion (mBIC) for 
given data set partition and clusters' dimensionalities. In each cluster we 
assume that variables are spanned by few factors. Considering maximum 
likelihood we get that those factors are in fact principal components. 
Additionally, it uses by default an informative prior distribution on models.
}
\keyword{internal}
