% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_names.R
\name{sample_names}
\alias{sample_names}
\title{Display sample names}
\usage{
sample_names(vcf_source, n_samples = NULL)
}
\arguments{
\item{vcf_source}{An object with \code{VCFFeatureSource} class, usually the
output of the \code{vs_read_vcf()}.}

\item{n_samples}{The number os samples to display.}
}
\value{
spark_jobj, shell_jobj
}
\description{
This function display the first N variant names.
}
\examples{
\dontrun{
library(sparklyr)

sc <- spark_connect(master = "local")
vsc <- vs_connect(sc)

hipster_vcf <- vs_read_vcf(vsc, 
                           system.file("extdata/hipster.vcf.bz2",
                                       package =  "variantspark"))

sample_names(hipster_vcf, 3)
}

}
