% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_read_labels.R
\name{vs_read_labels}
\alias{vs_read_labels}
\title{Reading labels}
\usage{
vs_read_labels(vsc, path, label = "label")
}
\arguments{
\item{vsc}{A variantspark connection.}

\item{path}{The file's path.}

\item{label}{A string with the label column name.}
}
\value{
spark_jobj, shell_jobj
}
\description{
This function reads only the label column of a CSV file and returns a \code{jobj}
object from \code{CsvLabelSource} scala class.
}
\examples{
 
\dontrun{
library(sparklyr)

sc <- spark_connect(master = "local")
vsc <- vs_context(sc)

labels <- vs_read_labels(vsc, 
                         system.file("extdata/hipster_labels.txt",
                                      package = "variantspark"))

labels 
}
}
