% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPBDB.R
\name{downloadPBDB}
\alias{downloadPBDB}
\title{Download Occurrences from the Paleobiology Database}
\usage{
downloadPBDB(Taxa, StartInterval = "Pliocene",
  StopInterval = "Pleistocene")
}
\arguments{
\item{Taxa}{a character vector}

\item{StartInterval}{a character vector}

\item{StopInterval}{a character vector}
}
\value{
a data frame
}
\description{
Downloads a data frame of Paleobiology Database fossil occurrences.
}
\details{
Downloads a data frame of Paleobiology Database fossil occurrences matching certain taxonomic groups and age range. This is simply a convenience function for rapid data download, and only returns the most generically useful fields. Go directly to the Paleobiology Database to make more complex searches or access additional fields. This function makes use of the RCurl package.

\itemize{
\item{ocurrence_no:} {The Paleobiology Database occurrence number.}
\item{collection_no:} {The Paleobiology Database collection number.}
\item{reference_no:} {The Paleobiology Database reference number.}
\item{Classifications:} {The stated Linnean classification of the occurence from phylum through genus. See \code{cleanTaxonomy} for how to simplify these fields.}
\item{accepted_name:} {The highest resolution taxonomic name assigned to the occurrence.}
\item{Geologic Intervals:} {The earliest possible age of the occurrence and latest possible age of the occurrence, expressed in terms of geologic intervals. See \code{constrainAge} for how to simplify these fields.}
\item{Numeric Ages:} {The earliest possible age of the occurrence and latest possible age of the occurrence, expressed as millions of years ago.}
\item{Geolocation:} {Both present-day and rotated paleocoordinates of the occurrence. The geoplate id used by the rotation model is also included. The key for geoplate ids can be found in the Paleobiology Database API documentation.}
 }
}
\examples{

# Download a test dataset of Ypresian bivalves.
# DataPBDB<-downloadPBDB(Taxa="Bivalvia",StartInterval="Ypresian",StopInterval="Ypresian")

# Download a test dataset of Ordovician-Silurian trilobites and brachiopods.
# DataPBDB<-downloadPBDB(c("Trilobita","Brachiopoda"),"Ordovician","Silurian")

}
\author{
Andrew A. Zaffos
}
