% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadPlaces.R
\name{downloadPlaces}
\alias{downloadPlaces}
\alias{trueWOF}
\title{Download Shapefile of Places}
\usage{
downloadPlaces(Place = "Wisconsin", Type = "region")
}
\arguments{
\item{Place}{A character string; the name of a place}

\item{Type}{A character string; a type of place}
}
\value{
An rgdal compatible shapefile
}
\description{
Download a shapefile of a geolocation from the Macrostrat API's implementation of the Who's on First database by MapZen.
}
\details{
Download a shapefile of a geolocation from the \href{https://macrostrat.org}{Macrostrat} API. The Macrostrat database provides a GeoJSON of a particular location given the location's \code{name} and \code{type}. Type can be of the categories: \code{"continent"}, \code{"country"}, \code{"region"}, \code{"county"}, and \code{"locality"}.

If multiple locations of the same type share the same name (e.g., Alexandria), the route will return a feature collection of all matching polygons.
}
\examples{

# Download a polygon of Dane County, Wisconsin, United States, North America
# DaneCounty<-downloadPlaces(Place="Dane",Type="county")

# Download a polygon of Wisconsin, United States, North America
# Wisconsin<-downloadPlaces(Place="Wisconsin",Type="region")

# Download a polygon of North America
# NorthAmerica<-downloadPlaces(Place="North America",Type="continent")

}
\author{
Andrew A. Zaffos
}
