% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vietnamcode.R
\name{vietnamcode}
\alias{vietnamcode}
\title{Convert Vietnam provincial ID}
\usage{
vietnamcode(sourcevar, origin = c("province_name", "enterprise_census",
  "enterprise_census_old", "enterprise_census_c", "pci"),
  destination = c("province_name", "province_name_diacritics",
  "enterprise_census", "enterprise_census_old", "enterprise_census_c", "pci"))
}
\arguments{
\item{sourcevar}{Character vector that contains the codes or province names to be converted}

\item{origin}{String that indicates the coding scheme of origin}

\item{destination}{String that indicates the coding scheme of destination}
}
\description{
Converts Vietnam's provinces' names and ID across different formats. Handles
diacritics and different spellings.
}
\note{
Supports the following coding schemes:
\itemize{
 \item{province_name}
 \item{province_name_diacritics}
 \item{enterprise_censusm enterprise_census_old, enterprise_census_c: }{the same as GSO code}
 \item{pci: }{Provincial Competitiveness Index}
}
}
\examples{
codes.of.origin <- vietnamcode::vietnamcode_data$province_name # Vector of values to be converted
vietnamcode(codes.of.origin, "province_name", "pci")
}
\keyword{vietnamcode}

