% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_viewshed.R
\name{visualize_viewshed}
\alias{visualize_viewshed}
\title{visualize_viewshed}
\usage{
visualize_viewshed(viewshed, plottype = "", outputtype = "")
}
\arguments{
\item{viewshed}{Viewshed object}

\item{plottype}{Character, specifying the type of visualization ("polygon" or
"raster").}

\item{outputtype}{Character, specifying the type of output object ("raster"
or "polygon").}
}
\value{
Visualized viewshed as either a raster or polygon object,
depending on the outputtype specified.
}
\description{
The visualize_viewshed function is designed for the visualization
of a viewshed analysis, providing users with various options for visualizing
the results. The function works with a viewshed object and offers multiple
plotting and output types.
}
\examples{
\donttest{
# Load a viewpoint
test_viewpoint <- sf::read_sf(system.file("test_viewpoint.shp", package = "viewscape"))
# load dsm raster
dsm <- terra::rast(system.file("test_dsm.tif", package ="viewscape"))
#Compute viewshed
viewshed <- compute_viewshed(dsm = dsm,
                             viewpoints = test_viewpoint,
                             offset_viewpoint = 6)
# Visualize the viewshed as polygons
visualize_viewshed(viewshed, plottype = "polygon")
# Visualize the viewshed as a raster
visualize_viewshed(viewshed, plottype = "raster")
# Get the visualized viewshed as a polygon object
polygon_viewshed <- visualize_viewshed(viewshed,
                                       plottype = "polygon",
                                       outputtype = "polygon")
}
}
