% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loccos.R
\name{loccos}
\alias{loccos}
\title{Leaving One Component Combination Out Scatter plot}
\usage{
loccos(
  model,
  sep = "+",
  combination = NULL,
  random = TRUE,
  z_value = FALSE,
  histogram = TRUE,
  histogram.color = "blue"
)
}
\arguments{
\item{model}{An object of class \code{\link[netmeta]{netmeta}}.}

\item{sep}{A single character that defines the separator between interventions components.}

\item{combination}{A single character that specifies the component combination of interest.}

\item{random}{\code{logical}. If \code{TRUE} the random-effects NMA model is used instead of the fixed-effect NMA model.}

\item{z_value}{\code{logical}. If \code{TRUE} z-values are used instead of interventions effects.}

\item{histogram}{\code{logical}. If \code{TRUE} histograms are added to the plot.}

\item{histogram.color}{A single character that specifies the color of the histogram. See \code{\link[ggExtra]{ggMarginal}} for more details.}
}
\value{
An object of class \code{\link[ggplot2]{ggplot}}.
}
\description{
The function based on the network meta-analysis (NMA) estimates explores if a set of components has a
positive or a negative impact on the outcome, by creating a scatter plot based on the set of
interventions that differ by a specific set of components.
}
\details{
Axis y represents the intervention's effect when the component combination is not included in the
intervention, while axis x represents the intervention's effect when is included.
Line \eqn{y = x} splits the plot in two parts. For a beneficial outcome, dots above the line
indicates that the inclusion of component combination balk the intervention's efficacy, while
dots below the line indicate that the inclusion of the component combination increases intervention's efficacy.
The opposite holds for harmful outcomes.

The component combination of interest is specified by the argument \code{combination}. For example, if \code{combination = "A"}, the
function plots all the interventions that differ by the component \code{"A"}. If \code{combination = NULL}, all interventions
that differ by one component are plotted.

The function by default uses the NMA relative effects estimates, but it can be adjusted to use the z-values by setting the argument \code{z_value = TRUE}.
Histograms for the nodes that include and not include the component combination can be added to the scatter plot,
by setting the argument \code{histogram = TRUE}.
}
\note{
In the case of dichotomous outcomes, the log-scale is used for both axis. Also, the function can be applied
only in network meta-analysis models that contain multi-component interventions.
}
\examples{
data(nmaMACE)
loccos(model = nmaMACE, combination = c("B"))

}
