% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmr-methods.R
\name{vmrConfigSSH}
\alias{vmrConfigSSH}
\title{Configure ssh}
\usage{
vmrConfigSSH(
  vmr,
  ssh_user = "vagrant",
  ssh_pwd = "vagrant",
  port = "",
  ssh_private_key_path = ""
)
}
\arguments{
\item{vmr}{a \strong{vmr} object}

\item{ssh_user}{the ssh user (default 'vagrant')}

\item{ssh_pwd}{the ssh pwd if any (default 'vagrant')}

\item{port}{the ssh port (default empty)}

\item{ssh_private_key_path}{path to the private ssh key to use (default empty, use insecure vagrant key)}
}
\value{
an updated \strong{vmr} object
}
\description{
Configure ssh credential.
}
\details{
by default \strong{vmr} use vagrant as user/password and insecure key
for ssh connection. This behavior can be change here, by setting an another
user and/or ssh keys. Calling with no arguments will disable this option.
Be careful, ssh using only password may result of \emph{vmr} functions bugs.
}
\examples{
\dontrun{
vmr <- vmrConfigSSH(ssh_user = "John", ssh_pwd = "d0e", port = "22")
vmr <- vmrConfigSSH(ssh_user = "John", private_key_path = "/path/to/private/key/")
}
}
