% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidates_get_by_levenshtein.R
\name{candidates_get_by_levenshtein}
\alias{candidates_get_by_levenshtein}
\title{Get candidate data by Levenshtein distance from last name}
\usage{
candidates_get_by_levenshtein(
  last_names,
  election_years = lubridate::year(lubridate::today()),
  stage_ids = "",
  all = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{last_names}{Vector of candidate last names}

\item{election_years}{Vector of election years. Default is the current year.}

\item{stage_ids}{The \code{stage_id} of the election (\code{"P"} for primary or \code{"G"} for general). See also \code{\link{election_get_election_by_year_state}}.}

\item{all}{Boolean: should all possible combinations of the variables be searched for, or just the exact combination of them in the order they are supplied?}

\item{verbose}{Should cases when no data is available be messaged?}
}
\value{
A dataframe of candidates and their attributes. If a given \code{last_name} + \code{election_year} + \code{stage_id} combination returns no data, that row will be filled with \code{NA}s.
}
\description{
From the API docs, \url{http://api.votesmart.org/docs/Candidates.html}, "This method grabs a list of candidates according to a fuzzy lastname match."
}
\details{
The actual Levenshtein distance of the result from the \code{last_name} provided is not available from the API.
}
\examples{
\dontrun{
candidates_get_by_levenshtein(c("Bookr", "Klobucar"), 2020)
}
}
