#' Azure DevOps Project Build Definition Information
#'
#' @description
#' These functions will allow you to scrape build definition information from Azure DevOps.
#'
#' @details
#' For more information about the build definition API calls check
#' \url{https://docs.microsoft.com/en-us/rest/api/azure/devops/build/definitions/list}.
#'
#' @param domain The name of the Azure DevOps organization.
#' @param project the name of the project in \code{domain} to look at
#' @param auth_key authentication key generated by using \code{\link{vsts_auth_key}}
#' @param query a list of extra parameters that can be sent to the API call. Check details for access to list
#' of options.
#'
#' @examples
#' \dontrun{
#' # Add in own details to get a non-NULL output
#' auth_key <- vsts_auth_key("<username>", "<password>")
#' vsts_get_build_defs("domain", "project", auth_key)
#' }
#'
#' @rdname vsts_build_def
#' @export
vsts_get_build_defs <- function(domain, project, auth_key, query = NULL) {
  uri <- file.path(AZURE_HOME_URL, domain, project, "_apis/build/definitions?api-version=5.0")
  response <- httr::GET(uri, httr::add_headers(Authorization = auth_key), query = query)

  if (httr::status_code(response) != 200) {
    send_failure_message(response, "get build definition list")
    return(invisible(NULL))
  }

  httr::content(response, encoding = "UTF-8", simplifyDataFrame = TRUE)$value
}
