% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bws_secret.R
\name{get_bws_secret}
\alias{get_bws_secret}
\title{Get a secret from your Bitwarden Secrets Manager vault}
\usage{
get_bws_secret(
  key,
  bws_access_token = get_bws_access_token(),
  bws_server_url = get_bws_server_url()
)
}
\arguments{
\item{key}{A character string representing the key of the secret.}

\item{bws_access_token}{Optional. A character string representing the Bitwarden access token. Defaults to the value of the "BITWARDEN_ACCESS_TOKEN" environment variable.}

\item{bws_server_url}{Optional. A character string representing the Bitwarden server URL. Defaults to the value of the "BWS_SERVER_URL" environment variable. For example "https://vault.bitwarden.eu".}
}
\value{
A character string containing the value of the secret.
}
\description{
This function retrieves the value of a secret stored in your Bitwarden Secrets Manager vault using the specified key.
}
\examples{
\dontrun{
# Set environment variables for testing (example values)
Sys.setenv(BWS_ACCESS_TOKEN = "your_access_token_here")
Sys.setenv(BWS_SERVER_URL = "https://vault.bitwarden.eu")

# Retrieve a secret using a key (the key must exist in your vault)
my_secret <- get_bws_secret("my-secret-key")
print(my_secret)
}
}
