% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copras_assignment.r
\name{copras_assignment}
\alias{copras_assignment}
\title{COPRAS Method for Selection of Locations in a Warehouse}
\usage{
copras_assignment(goods_and_locations, weights = c(rep(0.2, 5)))
}
\arguments{
\item{goods_and_locations}{A data frame containing information about goods and their locations. It should include at least the following columns: ‘product‘, ‘location‘, ‘storage_time‘, ‘distance‘, ‘demand_ratio‘, ‘full_packages_demand_ratio‘, and ‘neighbors‘.}

\item{weights}{A numeric vector of weights for the criteria used in the COPRAS method. The default is ‘c(rep(0.2, 5))‘, representing the weights for storage time, distance (distance from the I/O point), demand ratio (degree of demand satisfaction), full packages demand ratio (degree of demand satisfaction in full packages), and number of neighbors (number of other items on the pick list in the neighborhood of analyzed location), respectively.}
}
\value{
A list of results for each product, where each result includes:
- `normalized_and_weighted`: A data frame containing the normalized and weighted values for the criteria, along with the COPRAS scores (`q`) and rankings (`rank`) for each location.
- `copras`: A data frame containing the selected locations for each product based on the COPRAS method, with columns `product`, `location`, `rank`, and `demand_ratio`.
}
\description{
This function allows for selection of locations in a warehouse to be visited by the picker during order picking using the COPRAS (COmplex PRoportional ASsessment) method. The method applies weighted criteria such as storage time, distance from the I/O (depot) point, degree of demand satisfaction, degree of demand satisfaction in full packages, and the number of other items on the pick list in the neighborhood of analyzed location to determine the selection of locations that satisfies the given take-out strategy.
}
\details{
The function normalizes the criteria for each product and multiplies them by the provided weights. It then computes two scores, `si_plus` (positive criteria) and `si_minus` (negative criteria), which are used to calculate the COPRAS score (`q`). The function selects the best locations based on the highest COPRAS score while ensuring that the cumulative demand ratio for the selected locations meets or exceeds 1 (i.e., satisfies demand).
}
\examples{
# Assuming `goods_and_locations` is a data frame with appropriate columns
scenario2 <- generate_sample_goods_and_locatons_scenario(warehouse_height = 10,
warehouse_width = 10,nr_goods = 5)
copras <- copras_assignment(scenario2)

}
\references{
Gudehus, T., & Kotzab, H. (2012). *Comprehensive Logistics*. Springer Berlin Heidelberg.
\doi{10.1007/978-3-642-24367-7}

Zavadskas, E. K., Kaklauskas, A., & Šarka, V. (1994). The new method of multicriteria complex proportional assessment projects.
In E. K. Zavadskas & P. Linnert (Eds.), *Technological and economic development of economy. Volume 3. Business Management* (pp. 131–140). Vilnius: „Technika”.
}
\author{
Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}

Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}
}
