% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Acf.R
\name{acf.univ}
\alias{acf.univ}
\title{Computation of autocovariance and autocorrelation for an ARMA residuals.}
\usage{
acf.univ(ar = NULL, ma = NULL, y, h, e = NULL)
}
\arguments{
\item{ar}{Vector of AR coefficients. If \code{NULL},  it is a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL},  it is a AR process.}

\item{y}{Univariate time series.}

\item{h}{Given lag to compute autocovariance and autocorrelation, with h an integer.}

\item{e}{Vector of residuals of the time series.  If \code{NULL}, the function will compute it.}
}
\value{
A list with :
\describe{
    \item{\code{autocov}}{Value of the autocovariance.}
    \item{\code{autocor}}{Value of the autocorrelation.}
}
}
\description{
Computes empirical autocovariances and autocorrelations
 functions for an ARMA process for only one given lag.
}
\examples{
param.estim <- estimation(p = 1,  q = 1, y = CAC40return.sq)
\donttest{acf.univ(ar = param.estim$ar, ma = param.estim$ma, y = CAC40return.sq,  h = 20)}


}
\seealso{
\code{\link{acf.gamma_m}} for autocorrelation and autocovariance for all h lag.
}
