% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedinteractionweatherindices.R
\name{i.wwi}
\alias{i.wwi}
\title{Weighted Interaction Weather Indices}
\usage{
i.wwi(y, weatherp1, weatherp2)
}
\arguments{
\item{y}{A vector of yearly yield data for t years}

\item{weatherp1}{Weekly weather data for t years as vector for first weather variable(total observations= number of years*number of weeks in each year)}

\item{weatherp2}{Weekly weather data for t years as vector for second weather variable(total observations= number of years*number of weeks in each year)}
}
\value{
A vector of interaction weather indices
}
\description{
Converts the weekly interaction of two weather variable into yearly weighted interaction weather indices with weights being the correlation coefficient between weekly weather data over the years and crop yield over the years
}
\examples{
data(Burdwanweather) #Weekly weather data for the rice growing season in Burdwan
data(Burdwanriceyield) #Yearly Yield data of rice  in Burdwan
i.wwi.maxmintem<-i.wwi(Burdwanriceyield$burdwan,Burdwanweather$Max.Temperature,
                       Burdwanweather$Min.Temperature)
i.wwi.maxmintem
}
\references{
Jain, R. C., Agrawal, R., & Jha, M. P. (1980). Effect of climatic variables on rice yield and its forecast. MAUSAM, 31(4), 591-596.
}
