% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_conversions.R
\name{fahrenheit.to.kelvin}
\alias{fahrenheit.to.kelvin}
\title{Convert from Fahrenheit to Kelvin.}
\usage{
fahrenheit.to.kelvin(T.fahrenheit, round = 2)
}
\arguments{
\item{T.fahrenheit}{Numeric vector of temperatures in Fahrenheit.}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of temperature values in Kelvin.
}
\description{
\code{fahrenheit.to.kelvin} creates a numeric vector of temperatures in
   Kelvin from a numeric vector of temperatures in Fahrenheit.
}
\note{
Equations are from the source code for the National Oceanic and
     Atmospheric Association's
    \href{http://www.srh.noaa.gov/epz/?n=wxcalc_tempconvert}{online
    temperature converter}.
}
\examples{
# Convert from Fahrenheit to Kelvin.
data(norfolk)
norfolk$TempuratureK <- fahrenheit.to.kelvin(norfolk$TemperatureF)
norfolk

}
\author{
#' Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
\seealso{
\code{\link{kelvin.to.fahrenheit}}
}

