% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readers.R
\name{read_squid}
\alias{read_squid}
\title{read Squid files}
\usage{
read_squid(file, has_header = FALSE)
}
\arguments{
\item{file}{the full path to the CLF-formatted file you want to read.}

\item{has_header}{whether or not the file has a header row. Set to FALSE by
default.}
}
\description{
the Squid default log formats are either the CLF - for which, use
\code{\link{read_clf}} - or the "native" Squid format, which is described in more detail
below. \code{read_squid} allows you to read the latter.
}
\details{
The log format for Squid servers can be custom-set, but by default follows one of two
patterns; it's either the Common Log Format (CLF), which you can read in with
\code{\link{read_clf}}, or the "native log format", a Squid-specific format handled
by this function. It consists of the fields:

\itemize{
 \item{timestamp:} {the timestamp identifying when the request was received. This is
 stored (from the file's point of view) as a count of seconds, in UNIX time:
 \code{read_squid} turns them into POSIXlt timestamps, assuming UTC as an
 origin timezone.}
 \item{time_elapsed:} the amount of time (in milliseconds) that the connection and fulfilment
 of the request lasted for.
 \item{ip_address:} {the IP address of the remote host making the request.}
 \item{status_code:} {the status code and Squid response code associated with that request,
 stored as a single field. This can be split into two distinct fields with \code{\link{split_squid}}}
 \item{bytes_sent:} {the number of bytes sent}
 \item{http_method:} {the HTTP method (POST, GET, etc) used.}
 \item{url: }{the URL of the requested asset.}
 \item{remote_user_ident:} {the \href{https://tools.ietf.org/html/rfc1413}{RFC 1413} remote
 user identifier.}
 \item{peer_info:} {the status of how forwarding to a peer server was handled and, if the
 request was forwarded, the server it was sent to.}
}
}
\examples{
#Read in an example Squid file provided with the webreadr package.
data <- read_squid(system.file("extdata/log.squid", package = "webreadr"))
}
\seealso{
\code{\link{read_clf}} for the Common Log Format (also used by Squids), and
\code{\link{split_squid}} for splitting the "status_code" field into its component parts.
}

