% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_distributions.R
\name{dist_delay.default}
\alias{dist_delay.default}
\title{Parameter Estimation of a Delay Distribution}
\usage{
\method{dist_delay}{default}(..., date_1, date_2, distribution = c("lognormal", "exponential"))
}
\arguments{
\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{date_1}{A vector of class \code{character} or \code{Date}, in the format "yyyy-mm-dd",
representing the earlier of the two dates belonging to a particular delay.
Use \code{NA} for missing elements.

If more than one delay is to be considered, use a list where the first element
is the earlier date of the first delay, the second element is the earlier date
of the second delay, and so forth (see 'Examples').}

\item{date_2}{A vector of class \code{character} or \code{Date} in the format "yyyy-mm-dd".
\code{date_2} is the counterpart of \code{date_1} and is used the same as \code{date_1}, just with
the later date(s) of the particular delay(s). Use \code{NA} for missing elements.}

\item{distribution}{Supposed distribution of the respective delay.}
}
\value{
A list with class \code{wt_delay_estimation} which contains:
\itemize{
\item \code{coefficients} : A named vector of estimated parameter(s).
\item \code{delay} : A numeric vector of element-wise computed differences in days.
\item \code{distribution} : Specified distribution.
}

If more than one delay was considered, the resulting output is a list with class
\code{wt_delay_estimation_list}. In this case each list element has class
\code{wt_delay_estimation} and the items listed above, are included.
}
\description{
This function models a delay (in days) random variable (e.g. in logistic,
registration, report) using a supposed continuous distribution. First, the
element-wise differences in days of both vectors \code{date_1} and \code{date_2} are
calculated and then the parameter(s) of the assumed
distribution is (are) estimated with maximum likelihood. See 'Details' for
more information.
}
\details{
The distribution parameter(s) is (are) determined on the basis of complete
cases, i.e. there is no \code{NA} in one of the related vector elements
\code{c(date_1[i], date_2[i])}. Time differences less than or equal to zero are
not considered as well.
}
\examples{
# Example 1 - Delay in registration:
params_delay_regist  <- dist_delay(
  date_1 = field_data$production_date,
  date_2 = field_data$registration_date,
  distribution = "lognormal"
)

# Example 2 - Delay in report:
params_delay_report  <- dist_delay(
  date_1 = field_data$repair_date,
  date_2 = field_data$report_date,
  distribution = "exponential"
)

# Example 3 - Delays in registration and report with same distribution:
params_delays  <- dist_delay(
  date_1 = list(field_data$production_date, field_data$repair_date),
  date_2 = list(field_data$registration_date, field_data$report_date),
  distribution = "lognormal"
)

# Example 4 - Delays in registration and report with different distributions:
params_delays_2  <- dist_delay(
  date_1 = list(field_data$production_date, field_data$repair_date),
  date_2 = list(field_data$registration_date, field_data$report_date),
  distribution = c("lognormal", "exponential")
)

}
\seealso{
\link{dist_delay}
}
