% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_functions.R
\encoding{UTF-8}
\name{loglik_function}
\alias{loglik_function}
\alias{loglik_function.wt_reliability_data}
\title{Log-Likelihood Function for Parametric Lifetime Distributions}
\usage{
loglik_function(x, ...)

\method{loglik_function}{wt_reliability_data}(
  x,
  wts = rep(1, nrow(x)),
  dist_params,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "weibull3", "lognormal3", "loglogistic3", "exponential", "exponential2"),
  ...
)
}
\arguments{
\item{x}{A \code{tibble} with class \code{wt_reliability_data} returned by \link{reliability_data}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{wts}{Optional vector of case weights. The length of \code{wts} must be equal
to the number of observations in \code{x}.}

\item{dist_params}{A vector of parameters. An overview of the
distribution-specific parameters can be found in section 'Distributions'.}

\item{distribution}{Supposed distribution of the random variable.}
}
\value{
Returns the log-likelihood value for the parameters in \code{dist_params} given
the data.
}
\description{
This function computes the log-likelihood value with respect to a given set
of parameters. In terms of \emph{Maximum Likelihood Estimation} this function can
be optimized (\link[stats:optim]{optim}) to estimate the parameters and
variance-covariance matrix of the parameters.
}
\section{Distributions}{

The following table summarizes the available distributions and their parameters
\itemize{
\item \emph{location parameter} \eqn{\mu},
\item \emph{scale parameter} \eqn{\sigma} or \eqn{\theta} and
\item \emph{threshold parameter} \eqn{\gamma}.
}

The order within \code{dist_params} is given in the table header.\tabular{lccc}{
   \strong{\code{distribution}} \tab \strong{\code{dist_params[1]}} \tab \strong{\code{dist_params[2]}} \tab \strong{\code{dist_params[3]}} \cr
   \code{"sev"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"weibull"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"weibull3"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab \eqn{\gamma} \cr
   \code{"normal"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"lognormal"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"lognormal3"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab \eqn{\gamma} \cr
   \code{"logistic"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"loglogistic"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab - \cr
   \code{"loglogistic3"} \tab \eqn{\mu} \tab \eqn{\sigma} \tab \eqn{\gamma} \cr
   \code{"exponential"} \tab \eqn{\theta} \tab - \tab - \cr
   \code{"exponential2"} \tab \eqn{\theta} \tab \eqn{\gamma} \tab - \cr
}
}

\examples{
# Reliability data preparation:
data <- reliability_data(
  alloy,
  x = cycles,
  status = status
)

# Example 1 - Evaluating Log-Likelihood function of two-parametric weibull:
loglik_weib <- loglik_function(
  x = data,
  dist_params = c(5.29, 0.33),
  distribution = "weibull"
)

# Example 2 - Evaluating Log-Likelihood function of three-parametric weibull:
loglik_weib3 <- loglik_function(
  x = data,
  dist_params = c(4.54, 0.76, 92.99),
  distribution = "weibull3"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
