% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcs_mileage.R
\name{mcs_mileage.default}
\alias{mcs_mileage.default}
\title{Simulation of Unknown Covered Distances using a Monte Carlo Approach}
\usage{
\method{mcs_mileage}{default}(
  x,
  time,
  status = NULL,
  id = paste0("ID", seq_len(length(time))),
  distribution = c("lognormal", "exponential"),
  ...
)
}
\arguments{
\item{x}{A numeric vector of distances covered. Use \code{NA} for missing elements.}

\item{time}{A numeric vector of operating times. Use \code{NA} for missing elements.}

\item{status}{Optional argument. If used, it must contain binary data
(0 or 1) indicating whether a unit is a right censored observation (= 0) or a
failure (= 1).

If \code{status} is provided, class \code{wt_reliability_data} is assigned to the
output of \link{mcs_mileage}, which enables the direct application of \link{estimate_cdf}
on distances.}

\item{id}{Identification of every unit.}

\item{distribution}{Supposed distribution of the annual mileage.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}
}
\value{
A list with class \code{wt_mcs_mileage} containing the following elements:
\itemize{
\item \code{data} : A \code{tibble} returned by \link{mcs_mileage_data} where two modifications
has been made:
\itemize{
\item If the column \code{status} exists, the \code{tibble} has additional classes
\code{wt_mcs_data} and \code{wt_reliability_data}. Otherwise, the \code{tibble} only has
the additional class \code{wt_mcs_data} (which is not supported by \link{estimate_cdf}).
\item The column \code{mileage} is renamed to \code{x} (to be in accordance with
\link{reliability_data}) and contains simulated distances for incomplete
observations and input distances for the complete observations.
}
\item \code{sim_data} : A \code{tibble} with column \code{sim_mileage} that holds the simulated
distances for incomplete cases and \code{0} for complete cases.
\item \code{model_estimation} : A list returned by \link{dist_mileage}.
}
}
\description{
This function simulates distances for units where these are unknown.

First, random numbers of the annual mileage distribution, estimated by
\link{dist_mileage}, are drawn. Second, the drawn annual distances are
converted with respect to the actual operating times (in days) using a linear
relationship. See 'Details'.
}
\details{
\strong{Assumption of linear relationship}: Imagine the distance of the vehicle
is unknown. A distance of 3500.25 kilometers (km) was drawn from the annual
distribution and the known operating time is 200 days (d). So the resulting
distance of this vehicle is
\deqn{3500.25 km \cdot (\frac{200 d} {365 d}) = 1917.945 km}{%
3500.25 km * (200 d / 365 d) = 1917.945 km}
}
\examples{
# Example 1 - Reproducibility of drawn random numbers:
set.seed(1234)
mcs_distances <- mcs_mileage(
  x = field_data$mileage,
  time = field_data$dis,
  status = field_data$status,
  id = field_data$vin,
  distribution = "lognormal"
)

# Example 2 - MCS for distances with exponential annual mileage distribution:
mcs_distances_2 <- mcs_mileage(
  x = field_data$mileage,
  time = field_data$dis,
  status = field_data$status,
  id = field_data$vin,
  distribution = "exponential"
)

# Example 3 - MCS for distances with downstream probability estimation:
## Apply 'estimate_cdf()' to *$data:
prob_estimation <- estimate_cdf(
  x = mcs_distances$data,
  methods = "kaplan"
)

## Apply 'plot_prob()':
plot_prob_estimation <- plot_prob(prob_estimation)

}
\seealso{
\link{dist_mileage} for the determination of a parametric annual mileage
distribution and \link{estimate_cdf} for the estimation of failure probabilities.
}
