% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability_data.R
\name{reliability_data}
\alias{reliability_data}
\title{Reliability Data}
\usage{
reliability_data(data = NULL, x, status, id = NULL, .keep_all = FALSE)
}
\arguments{
\item{data}{Either \code{NULL} or a \code{data.frame}. If data is \code{NULL},
\code{x}, \code{status} and \code{id} must be vectors containing
the data. Otherwise \code{x}, \code{status} and \code{id} can be either column
names or column positions.}

\item{x}{Lifetime data, that means any characteristic influencing the reliability
of a product, e.g. operating time (days/months in service), mileage (km, miles),
load cycles.}

\item{status}{Binary data (0 or 1) indicating whether a unit is a right
censored observation (= 0) or a failure (= 1).}

\item{id}{Identification of every unit.}

\item{.keep_all}{If \code{TRUE} keep remaining variables in \code{data}.}
}
\value{
A tibble with class \code{wt_reliability_data} containing the following
columns (if \code{.keep_all = FALSE}):
\itemize{
\item \code{x} : Lifetime characteristic.
\item \code{status} : Binary data (0 or 1) indicating whether a unit is a right
censored observation (= 0) or a failure (= 1).
\item \code{id} : Identification for every unit.
}

If \code{.keep_all = TRUE}, the remaining columns of \code{data} are also preserved.

If \code{!is.null(data)} the attribute \code{characteristic} holds the name of the
characteristic described by \code{x}. Otherwise it is set to \code{"x"}.
}
\description{
Create consistent reliability data based on an existing \code{data.frame}
(preferred) or on multiple equal length vectors.
}
\examples{
# Example 1 -  Based on an existing data.frame/tibble and column names:
data <- reliability_data(
  data = shock,
  x = distance,
  status = status
)

# Example 2 - Based on an existing data.frame/tibble and column positions:
data_2 <- reliability_data(
  data = shock,
  x = 1,
  status = 3
)

# Example 3 - Keep all variables of the tibble/data.frame entered to argument data:
data_3 <- reliability_data(
  data = shock,
  x = distance,
  status = status,
  .keep_all = TRUE
)

# Example 4 - Based on vectors:
cycles <- alloy$cycles
state <- alloy$status
id <- "XXXXXX"

data_4 <- reliability_data(
  x = cycles,
  status = state,
  id = id
)

}
