% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{nametoWikiURL}
\alias{nametoWikiURL}
\title{Create the Wikipedia URL of a name or entry.}
\usage{
nametoWikiURL(name, language = "en")
}
\arguments{
\item{name}{A vector consisting of one or more Wikipedia's entry (i.e., topic or person).}

\item{language}{The language of the Wikipedia page version. This should consist of an ISO language code (default = "en").}
}
\value{
A character vector of names' URLs.
}
\description{
Create the Wikipedia URL of a name or entry.
}
\details{
This function adds the Wikipedia URL to a entry or name, i.e., "Max Weber" converts into "https://es.wikipedia.org/wiki/Max_Weber". It also manages different the languages of Wikipedia thru the abbreviated two-letter language parameter, i.e., "en" = "english".
}
\examples{
## When extracting a single item;
nametoWikiURL("Computer", language = "en")

## When extracting two objetcs;
A <- c("Computer", "Operating system")
nametoWikiURL(A)

## Same when three or more items;
B <- c("Socrates", "Plato" , "Aristotle")
nametoWikiURL(B)
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
