% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qkn_coeff.R
\name{qkn_coeff}
\alias{qkn_coeff}
\title{Inverse of a Coefficient Matrix \eqn{\tilde{\mathcal{C}}_k}}
\usage{
qkn_coeff(k, alpha = 2)
}
\arguments{
\item{k}{The order of the \eqn{\tilde{\mathcal{C}}_k} matrix}

\item{alpha}{The type of beta-Wishart distribution (\eqn{\alpha=2/\beta}):
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
Inverse of a coefficient matrix \eqn{\tilde{\mathcal{C}}_k} that allows us to
obtain \eqn{E[p_{\lambda}(W^{-1})W^{-r}]}, where \eqn{r+|\lambda|=k}
and \eqn{W ~ W_m^{\beta}(n,\Sigma)}.  The matrix is represented as a
3-dimensional array where each slice along the third dimension represents
a coefficient matrix of the polynomial in descending powers of \eqn{\tilde{n}}.
}
\description{
This function computes the inverse of the coefficient matrix \eqn{\tilde{\mathcal{C}}_k}
}
\examples{
# Example 1:
qkn_coeff(2) # For real Wishart distribution with k = 2
# Example 2:
qkn_coeff(3, 1) # For complex Wishart distribution with k = 3

# Example 3:
qkn_coeff(2, 1/2) # For quaternion Wishart distribution with k = 2

}
