% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.textmodel_wordmap}
\alias{predict.textmodel_wordmap}
\title{Predict the most likely class of documents}
\usage{
\method{predict}{textmodel_wordmap}(
  object,
  newdata = NULL,
  confidence = FALSE,
  rank = 1L,
  type = c("top", "all"),
  rescale = FALSE,
  min_conf = -Inf,
  min_n = 0L,
  ...
)
}
\arguments{
\item{object}{a model fitted by \code{\link[=textmodel_wordmap]{textmodel_wordmap()}}.}

\item{newdata}{a dfm on which prediction will be made.}

\item{confidence}{if \code{TRUE}, it returns likelihood ratio scores.}

\item{rank}{rank of the class to be predicted. Only used when \code{type = "top"}.}

\item{type}{if \code{top}, returns the most likely class specified by \code{rank};
otherwise return a matrix of likelihood ratio scores for all possible
classes.}

\item{rescale}{if \code{TRUE}, likelihood ratio scores are normalized using \code{\link[=scale]{scale()}}.
This affects both types of results.}

\item{min_conf}{returns \code{NA} when confidence is lower than this value.}

\item{min_n}{set the minimum number of polarity words in documents.}

\item{...}{not used.}
}
\value{
Returns predicted classes as a vector. If \code{confidence = TRUE},
it returns a list of two vectors:
\item{class}{predicted classes of documents.}
\item{confidence.fit}{the confidence of predictions.}
}
\description{
Predict document class using fitted Wordmap models.
}
