% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasttext.R
\name{fasttext}
\alias{fasttext}
\title{Extract word vectors from fasttext word embedding}
\source{
\url{https://fasttext.cc/}
}
\usage{
fasttext(
  text,
  tokenizer = text2vec::space_tokenizer,
  dim = 10L,
  type = c("skip-gram", "cbow"),
  window = 5L,
  loss = "hs",
  negative = 5L,
  n_iter = 5L,
  min_count = 5L,
  threads = 1L,
  composition = c("tibble", "data.frame", "matrix"),
  verbose = FALSE
)
}
\arguments{
\item{text}{Character string.}

\item{tokenizer}{Function, function to perform tokenization. Defaults to
\link[text2vec:tokenizers]{text2vec::space_tokenizer}.}

\item{dim}{Integer, number of dimension of the resulting word vectors.}

\item{type}{Character, the type of algorithm to use, either 'cbow' or
'skip-gram'. Defaults to 'skip-gram'.}

\item{window}{Integer, skip length between words. Defaults to 5.}

\item{loss}{Charcter, choice of loss function must be one of "ns", "hs", or
"softmax". See details for more Defaults to "hs".}

\item{negative}{integer with the number of negative samples. Only used when
loss = "ns".}

\item{n_iter}{Integer, number of training iterations. Defaults to 5.
\code{numeric = -1} defines early stopping strategy. Stop fitting
when one of two following conditions will be satisfied: (a) passed
all iterations (b) \code{cost_previous_iter / cost_current_iter - 1 <
    convergence_tol}. Defaults to -1.}

\item{min_count}{Integer, number of times a token should appear to be
considered in the model. Defaults to 5.}

\item{threads}{number of CPU threads to use. Defaults to 1.}

\item{composition}{Character, Either "tibble", "matrix", or "data.frame" for
the format out the resulting word vectors.}

\item{verbose}{Logical, controls whether progress is reported as operations
are executed.}
}
\value{
A \link[tibble:tibble-package]{tibble}, data.frame or matrix containing
the token in the first column and word vectors in the remaining columns.
}
\description{
The calculations are done with the fastTextR package.
}
\details{
The choice of loss functions are one of:
\itemize{
\item "ns" negative sampling
\item "hs" hierarchical softmax
\item "softmax" full softmax
}
}
\examples{
fasttext(fairy_tales, n_iter = 2)

# Custom tokenizer that splits on non-alphanumeric characters
fasttext(fairy_tales,
         n_iter = 2,
         tokenizer = function(x) strsplit(x, "[^[:alnum:]]+"))
}
\references{
Enriching Word Vectors with Subword Information, 2016, P.
Bojanowski, E. Grave, A. Joulin, T. Mikolov.
}
