% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_git_pull.R
\name{wflow_git_pull}
\alias{wflow_git_pull}
\title{Pull files from remote repository}
\usage{
wflow_git_pull(
  remote = NULL,
  branch = NULL,
  username = NULL,
  password = NULL,
  fail = TRUE,
  dry_run = FALSE,
  project = "."
)
}
\arguments{
\item{remote}{character (default: NULL). The name of the remote repository.
See Details for the default behavior.}

\item{branch}{character (default: NULL). The name of the branch in the remote
repository to pull from. If \code{NULL}, the name of the current local
branch is used.}

\item{username}{character (default: NULL). Username for online Git hosting
service (e.g. GitHub or GitLab). The user is prompted if necessary.}

\item{password}{character (default: NULL). Password for online Git hosting
service (e.g. GitHub or GitLab). The user is prompted if necessary.}

\item{fail}{logical (default: TRUE) Abort the pull if any merge conflicts
are detected. If you are sure you want to manually cleanup the merge
conflicts, set \code{fail = FALSE}. The argument \code{fail} is passed to
the git2r function \code{\link[git2r:reexports]{merge.git_repository}}.}

\item{dry_run}{logical (default: FALSE). Preview the proposed action but do
not actually pull from the remote repository.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
An object of class \code{wflow_git_pull}, which is a list with the
  following elements:

\itemize{

\item \bold{remote}: The remote repository.

\item \bold{branch}: The branch of the remote repository.

\item \bold{username}: Username for online Git hosting service (e.g. GitHub
or GitLab).

\item \bold{merge_result}: The \code{git_merge_result} object returned by
\link[git2r]{git2r} (only included if \code{dry_run == FALSE}).

\item \bold{fail}: The input argument \code{fail}.

\item \bold{dry_run}: The input argument \code{dry_run}.

\item \bold{protocol}: The authentication protocol for the remote repository
(either \code{"https"} or \code{"ssh"}.

\item \bold{project}: The input argument \code{project}.

}
}
\description{
\code{wflow_git_pull} pulls the remote files from your remote repository
online (e.g. GitHub or GitLab) into your repository on your local machine.
This is a convenience function to run Git commands from the R console instead
of the Terminal. The same functionality can be achieved by running \code{git
pull} in the Terminal.
}
\details{
\code{wflow_git_pull} tries to choose sensible defaults if the user does not
explicitly specify the remote repository and/or the remote branch:

\itemize{

\item If both \code{remote} and \code{branch} are \code{NULL},
\code{wflow_git_pull} checks to see if the current local branch is tracking a
remote branch. If yes, it pulls to this tracked remote branch.

\item If the argument \code{remote} is left as \code{NULL} and there is only
one remote, it is used.  If there is more than one remote, the one named
"origin" is used.

\item If the argument \code{branch} is left as \code{NULL}, the
name of the current local branch is used (referred to as \code{HEAD} by Git).

}

Under the hood, \code{wflow_git_pull} is a wrapper for
\code{\link[git2r]{pull}} from the package \link[git2r]{git2r}.
}
\examples{
\dontrun{

# Pull from remote repository
wflow_git_pull()
# Preview by running in dry run mode
wflow_git_pull(dry_run = TRUE)
}

}
