% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim_timespan.R
\name{anim_timespan}
\alias{anim_timespan}
\title{Get dates of individuals first and last sample}
\usage{
anim_timespan(individual_id, sample_date, sample_type, dead = "Tissue")
}
\arguments{
\item{individual_id}{Column in the dataframe of all samples containing
individual animal identifier code.
Defined as \code{dataframe$column}.}

\item{sample_date}{Column in the dataframe of all samples containing
the date of sample collection.
Must be in \code{Date} format. Defined as \code{dataframe$column}.}

\item{sample_type}{Column in the dataframe of all samples containing the data
on the type (eg. scat, tissue, saliva) of particular sample.
Defined as \code{dataframe$column}.}

\item{dead}{Single value or vector of different lethal sample types. If no lethal
samples are included in the sampledata the dead parameter can be set to \code{FALSE} (dead = \code{FALSE}).
Defaults to "Tissue".}
}
\value{
A data frame with four columns and one row for each \code{individual_id}.
Returned data frame columns correspond to individual identification key (\code{ID}),
date of first (\code{FirstSeen}) and last (\code{LastSeen}) sample of individual and
logical (\code{TRUE/FALSE}) value that identifies if the individual is dead (\code{IsDead}).
}
\description{
Takes data frame of all samples and returns the dates of individuals first
and last sample.
Besides that the functions determines if animal is dead based on predefined
sample type eg. tissue.
}
\examples{
anim_timespan(
  individual_id = wolf_samples$AnimalRef,
  sample_date = wolf_samples$Date,
  sample_type = wolf_samples$SType,
  dead = c("Tissue")
)
}
