% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randMassByMut.R
\name{randMassByMut}
\alias{randMassByMut}
\title{Make decoy mass by full randomization}
\usage{
randMassByMut(
  pepTab,
  randCha,
  useCol = "mass",
  negAvoid = TRUE,
  sepCol = FALSE,
  inDel = FALSE,
  nAlter = 1,
  setSeed = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{pepTab}{(matrix) typically table of petides, one column should match 'useCol' for numeric mass values}

\item{randCha}{(numeric) vector of possible mass alterations for random drawing}

\item{useCol}{(character)  column from 'pepTab' with mass values to make decoys}

\item{negAvoid}{(logical) if TRUE try avoiding 0 or negative random mass in result}

\item{sepCol}{(character) optional column from 'pepTab'}

\item{inDel}{(logical) switch to make random mass by insertion/deletion of 1 AA}

\item{nAlter}{(integer) number of alterations per peptide}

\item{setSeed}{(character) seed for random number generation set.seed()}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages and objects exportet to current session for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix with additional column 'decoyMass', or if 'sepCol'=FALSE as additional lines
}
\description{
Make full random decoy mass vector (mimick pepTab)
}
\examples{
pepTab1 <- cbind(no=11:12, seq=c("YVVDTS","YVVDTSK"), origNa="test.P000",
  ty=c("inter","Cter"),mass=c(681.308997360991,809.403960378691))
randMassByMut(pepTab1, corMutShift())
randMassByMut(pepTab1, corInDelShift(), inDel=TRUE)
}
\seealso{
\code{\link{randMassByStochastic}}
}
