% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicationFactory}
\alias{xegaGaReplicationFactory}
\title{Configure the replication function of a genetic algorithm.}
\usage{
xegaGaReplicationFactory(method = "Kid1")
}
\arguments{
\item{method}{A string specifying the replication function.}
}
\value{
A replication function for genes.
}
\description{
\code{xegaGaReplicationFactory()} implements the selection
             of a replication method. 

             Current support:

             \enumerate{
             \item "Kid1" returns \code{xegaGaReplicateGene()}.
             \item "Kid1Pipeline" returns 
                    \code{xegaGaReplicateGenePipeline()}.
             \item "Kid2" returns \code{xegaGaReplicate2Gene()}.
             \item "Kid2Pipeline" returns 
                    \code{xegaGaReplicate2GenePipeline()}.
             }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.001}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {gene}
Replicate<-xegaGaReplicationFactory("Kid1")
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes1<-Replicate(pop10, fit10, lFxegaGaGene)
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
Replicate<-xegaGaReplicationFactory("Kid2")
newgenes2<-Replicate(pop10, fit10, lFxegaGaGene)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaGaGene}},
\code{\link{xegaGaCrossoverFactory}()},
\code{\link{xegaGaGeneMapFactory}()},
\code{\link{xegaGaMutationFactory}()}
}
\concept{Configuration}
