% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timer.R
\name{Counted}
\alias{Counted}
\title{Transformation into a counted function}
\usage{
Counted(FUN, counter)
}
\arguments{
\item{FUN}{A function whose run time should be measured.}

\item{counter}{A counter generated by \code{newCounter()}.}
}
\value{
A counted function.
}
\description{
\code{Counted()} takes two functions as arguments: 
    The function whose call frequency 
    should be measured and a counter object created by \code{newCounter()}.
    It returns a counted function.
}
\examples{
    test<-function(v) {sum(v)} 
    testCounter<-newCounter()
    testCounted<-Counted(test, testCounter)
    testCounter("Show")
    testCounted(sample(10,10)); testCounted(sample(10,10))
    testCounter("Show")
}
\seealso{
Other Performance Measurement: 
\code{\link{Timed}()},
\code{\link{newCounter}()},
\code{\link{newTimer}()}
}
\concept{Performance Measurement}
