% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtbetween.R
\name{between_max}
\alias{between_max}
\title{Compute the maximum between-group}
\usage{
between_max(data, variable, id = NULL, t = NULL, na.rm = FALSE)
}
\arguments{
\item{data}{A data.frame or pdata.frame object containing the panel data.}

\item{variable}{The variable for which the maximum between-group effect is calculated.}

\item{id}{(Optional) Name of the individual identifier variable.}

\item{t}{(Optional) Name of the time identifier variable.}

\item{na.rm}{Logical. Should missing values be removed? Default is FALSE.}
}
\value{
The maximum between-group effect.
}
\description{
This function calculates the maximum between-group in a panel data.
}
\examples{
# Example using pdata.frame
data("Gasoline", package = "plm")
Gas <- pdata.frame(Gasoline, index = c("country", "year"), drop.index = TRUE)
between_max(Gas, variable = "lgaspcar")

# Using regular data.frame with id and t specified
data("Crime", package = "plm")
between_max(Crime, variable = "crmrte", id = "county", t = "year")

}
